import argparse
import sys

from AptFunctionsLibrary import *

#todo handle full root FS updates

parser = argparse.ArgumentParser(description="Trend APT package helper", formatter_class=argparse.ArgumentDefaultsHelpFormatter)
parser.add_argument("mode", help="Mode of operation: [check-update|download-update|install-update|package-candidates|download-size|system-image-download-size|system-image-url|system-image-candidates|download-system-image|print-apt-command|supported-repositories|dev]")
parser.add_argument("repository", help="Trend repository name: [trend-online-beta|trend-online-production|trend-offline|...]")
parser.add_argument("package", help="Package name")
parser.add_argument("-v", "--version", help="Package version")
args = parser.parse_args()
config = vars(args)

#print(config)

mode = config['mode']
repository = config['repository']
packageName = config['package']
packageVersion = config['version']

if  validateRepository(repository) != ReturnCode.Ok:
    repository = "trend-offline"

command = verifyDpkgCommand()
result, output = runBashCommand(command)
if result == False:
    print("apt dependency not found")
    sys.exit(ReturnCode.DpkgIsBroken.value)

if mode == 'supported-repositories':
    sys.exit(supportedAptRepositories().value)

if mode == 'check-update':
    sys.exit(aptCheckUpdate(repository, packageName).value)

if mode == 'check-ccmb':
    sys.exit(aptFetchCCMBVersion(repository, packageName, packageVersion).value)

if mode == 'download-update':
    sys.exit(aptDownloadUpdate(repository, packageName, packageVersion).value)

if mode == 'install-update':
    sys.exit(aptInstallUpdate(repository, packageName, packageVersion).value)

if mode == 'package-candidates':
    sys.exit(aptPackageCandidates(repository, packageName).value)

if mode == 'download-size':
    sys.exit(aptDownloadSize(repository, packageName, packageVersion).value)

if mode == 'system-image-download-size':
    sys.exit(systemImageDownloadSize(repository, packageName, packageVersion).value)

if mode == 'system-image-url':
    print("URL:", systemImageUrl(repository, packageVersion))
    sys.exit(ReturnCode.Ok.value)

if mode == 'system-image-candidates':
    sys.exit(systemImageCandidates(repository, packageName).value)

if mode == "download-system-image":
    sys.exit(downloadSystemImage(repository, packageName, packageVersion).value)

if mode == 'print-apt-command':
    print("command:", aptUpdateCommand(repository))
    sys.exit(ReturnCode.Ok.value)

if mode == 'dev':
    systemImageCandidates(repository, packageName)
#    print("url:", getRepositoryUrl(repository))
    #put some test code in here
    sys.exit(ReturnCode.Ok.value)

if mode == 'getUserNotice':
    sys.exit(aptGetUserNotice(repository, packageName, packageVersion).value)

print("Unsupported mode: " + mode)
sys.exit(ReturnCode.UnsupportedMode.value)
